#include <allegro.h>
#include <memory.h>

#include "main.h"
#include "castle.h"

CASTLE* castle_add(CASTLE **castles)
{
	CASTLE *new_castle = (CASTLE *) malloc(sizeof(CASTLE));

	if (new_castle)
	{
		new_castle->levy = 0;
		new_castle->player = -1;
		new_castle->x = -1;
		new_castle->y = -1;
		new_castle->next = *castles;
		*castles = new_castle;
	}

	return new_castle;
	
}

void castle_remove(CASTLE **castles, CASTLE *castle)
{
	CASTLE *prev = NULL;
	CASTLE *current = *castles;

	while (current)
	{
		if (current == castle)
		{
			if (!prev)
				*castles = current->next;
			else
				prev->next = current->next;

			free(castle);
			break;
		}

		prev = current;
		current = current->next;
	}

	return;
}

void castle_destroy(CASTLE **castles)
{
	CASTLE *castle = *castles;
	while (castle)
	{
		CASTLE *tmp = castle->next;
		free(castle);
		castle = tmp;
	}

	*castles = 0;
}
